#===================================================================
# Automatically build and publish this folder's content, only.
# This gallery has 121 images and 88 notes at last count (jun25).
#
# This script publishes the gallery on its host server.  See 
# ./_generate.sh for commands used to build the gallery itself. 
#
# This Unix Bash script is demo only: it requires a common.sh (not
# included), and on Windows either Cygwin, WSL, or DOS translation.
#
# Caution: requires Python 3.8+ on dev host today (~/.bash_profile).
#
# Launch this script from Terminal in its own folder, with:
#     cd $W/Posts/Current/Complete/trnpix
#     bash _publish.sh
#
# Also run by $W/_admin/BUILD-THUMBSPAGE-CLIENTS/_PUBLISH.sh, to 
# update all thumbspage (TP) external clients in a single step.
#
# See also: 
#     ./_generate.sh runs the thumbspage commands used to build 
#     this folder's 3 galleries, with alternative index layouts.
# 
#     TP's docetc/batchnotes.py collects .note files for spellchecks;
#     it's auto-run here, as it's referenced as a demo in TP docs.
#
#     TP's build/insert-analytics.py adds analytics JS code to HTML 
#     pages, after generation and before zip+upload. 
#
#-------------------------------------------------------------------
# Recent updates, latest last:
#
# - TP 2.3 allows console inputs to be provided with command 
#   args, instead of <<-EOF; see the new build command(s).
#
# - TP 2.3 allows popups' colors to deviate from the viewer-page
#   defaults; e.g., popupFgColor=\'#ddddd\' selects muted-white text.
#
# - The TP build command is now split off to subscript _generate.sh, 
#   for both local testing sans uploads, and TP's examples/trnpix.
#
# - Now publishes 2 alternative index pages with crosslinks:
#   fixed and dynamic layout.  See _generate.sh for the builds.
#
# - Now publishes a 3rd index-page variant: thumbs-only mode;
#   website links now prefer dynamic over both fixed and this.
#
# - tan => wheat for popups fg text; tan seems generally too 
#   dark, though this can vary per display, setting, and user.
# 
# - _HEADER: hardcoded UA analytics tag/code => replacement key,
#   so picks up GA4.  FOOTER: new, shorter link words from site.
#
# - As a provisional experiment, add analytics to all trnpix image
#   viewer pages (not just indexes); TP emits replacement keys.
#
# - thumbspage/examples/trnpix/_generate.sh runs _generate.sh here
#   but not _publish.sh here, which results in .html files without
#   analytics in $W/UNION, even though they have analytics at live 
#   site.  Must rerun this _publish.sh after a thumbspage publish. 
# 
# - Dec23: moved analytics tag below </head> in _HEADER.html.  Else
#   <title> may be missed, causing "(not set)" page titles in ga4 
#   reports (though timing dependent, and page-path reports fine).
#   The same should be done for viewer pages--and was in TP 3.0.
#
# - Jun25: rebuild with thumbspage 3.0; add a _viewable/ subfolder 
#   sans index.html so vetters can see all content; insert Apache
#   code in _viewable/'s .htaccess to display its .html files+ as 
#   unrendered plain text, and nicely via showcode.py; and fix a
#   nasty Bash issue triggered by new spaces in image filenames.
#
#   TP 3.0 makes dynamic index layout the preset default and mods 
#   some config presets per common practice; see _generate.sh.
#===================================================================


# Common defs, aliases, scp/ssh functions with keys (yours will vary)
source ~/MY-STUFF/Websites/_admin/BUILD-THUMBSPAGE-CLIENTS/common.sh

# Save zip to $C/thumbspage/_private?
SaveInTP=y


#-----------------------------------------------------------------
# GALLERY: build gallery, collect note files for spellcheck
#-----------------------------------------------------------------


# --See this folder's _generate.sh for gallery build commands--


# Run new-style gallery builds, now in a subscript
bash _generate.sh


# Run note batcher in '.' for spell/grammar check, and thumbspage 2.3 demo
py3 $C/thumbspage/docetc/batchnotes.py


#-----------------------------------------------------------------
# WEBSITE: add analytics, make _viewable/, build website image
#-----------------------------------------------------------------


# Add analytics to index pages, no longer hardcoded in _HEADER used by all
indexpages='index.html index-dynamic.html index-thumbsonly.html'
for indexpage in $indexpages; do
    py3 $M/insert-analytics.py $indexpage
done


# Add analytics to viewer pages too
# [jun25] now fails - filenames grew spaces and bash splits on them:   
# for viewpage in $(find . -path './_thumbspage*/*.html' -print); do
#     py3 $M/insert-analytics.py $viewpage
# done
#
# Instead, use gross Bash hackery to allow spaces in filenames from find.
# Not available on macos: readarray -d $'\0' files < <(find ... -print0).
# Would be longer but _much_ more coherent if coded in python (see os.walk).

while IFS= read -r -d $'\0' file; do
    py3 $M/insert-analytics.py "$file"
done < <(find . -path './_thumbspage*/*.html' -print0)


# [jun25] Copy content to a viewable subfolder (sans index.htlm(s)).
# May be able to show ".htaccess" and "index.py" but "_" rename is simple.

echo "Making _viewable/"
rm -rf _viewable
mkdir _viewable
cp -R -p *.txt *.sh *.html _htaccess _thumbspage* \
    *.jpg *.JPG *.png *.gif \
    *.note *.py *.original _viewable
mv _viewable/index.html _viewable/_index.html 
mv _viewable/index-dynamic.html _viewable/_index-dynamic.html 
mv _viewable/index-thumbsonly.html _viewable/_index-thumbsonly.html 


# [mar22] Copy Apache .htaccess for nicer index displays of subfolders themselves.
# Renaming to .htaccess here enables them in the subfolders to which they're copied.

subfolders='_thumbspage _thumbspage-dynamic _thumbspage-thumbsonly _viewable'
for subfolder in $subfolders; do
    cp -p _htaccess $subfolder/.htaccess
done


# [jun25] Extend Apache _viewable/.htaccess to serve .html files in that folder 
# (only) as plain text.  "AddType text/plain .html" not required if rewriting.
# The regex is from main .htaccess: here, may be overkill and requires the "R".

apacheinsert='
# Added by _publish.sh 
# Serve+show html and other files here and below as plain text, nicely

rewritecond %{HTTP_HOST} ^www.learning-python.com$ [OR]
rewritecond %{HTTP_HOST} ^learning-python.com$
rewriterule ^(?!(?:cgi\/|.*robots.txt))(_htaccess|.*\.(?:py|txt|pyw|sh|c|h|note|html))$ "https\:\/\/learning-python\.com\/cgi\/showcode\.py\?name\=trnpix/_viewable/$1" [R,NC]
'

hts='.htaccess _htaccess'
for ht in $hts; do
    echo -e "$apacheinsert" >> _viewable/$ht
done


# Build local website image (ymmv)
cd $W
py3 _PUBLISH.py | tail -n 20


#-----------------------------------------------------------------
# UPLOAD: zip by ziptools, upload zip by scp, unzip at site by ssh
#-----------------------------------------------------------------


# Combo folder made by _PUBLISH.py
cd UNION


# Fix file permissions for web access
find trnpix -type d -exec chmod 755 '{}' \;
find trnpix -type f -exec chmod 644 '{}' \;


# Zip
py3 $Z/zip-create.py trnpix.zip trnpix -skipcruft | tail -n 20


# Upload
SCP trnpix.zip htdocs


# Unzip
SSH <<-EOF
	cd htdocs
	rm -rf trnpix
	unzip -d . trnpix.zip
	rm trnpix.zip
	exit 
	EOF


# Save
if [ $SaveInTP == 'y' ]
then
    mv trnpix.zip $C/thumbspage/_private/trnpix--$stamp.zip
else
    rm trnpix.zip
fi
