#!/bin/bash
# ========================================================================
# Run this bash script in this folder to make just this folder's gallery:
#
#   ~/.../thumbspage/examples/trnpix$ bash _generate.sh
#
# To make all examples, run the script ../../build/generate-examples.py,
# which runs this script and all others like it.  This automates console 
# inputs, but requires a Unix-style bash shell; extrapolate for other 
# shells or run thumbspage manually elsewhere per _HOW-MADE.txt here. 
# This could use 2.3 input config args instead of <<EOF shell magic.
#
# This REGENERATES the external trnpix demo stored elsewhere in a website 
# folder; it won't work unless that website folder is present.   This now
# also copies the demo's {_generate, _publish}.sh, but with double "_".
#
# Caveat: as coded, these demos have the hosting site's analytics code
# embedded in them; please don't post them online verbatim.
#
# Caveat: trnpixcopy's setting must be changed for each new release #.
#
# Update [2.3]: this now runs a subscript, trnpix/_generate.sh, to remake
# trnpix content, instead of a command here which is apt to fall out of
# sync.  The subscript's command looks like this today (but may change!):
#
#   python3 $C/thumbspage/thumbspage.py . \
#              useDynamicIndexLayout=False \
#              inputCleanThumbsFolder=True inputThumbsPerRow=4 \
#              inputThumbMaxSize=100 inputUseViewerPages=True \
#              popupFgColor=\'tan\' \
#              popupOpacity=0.45
#
# Its former version was already out of synch when this was modified:
#   python3 ../../thumbspage.py $trnpix <<-EOF ... EOF
#
# Update [2.3]: results-2.3/__{generate, publish}.sh is copies of 
# trnpix's _{generate, publish}.sh build scripts.
#
# Update [2.3]: trnpix now builds both fixed and dynamic index pages,
# with html files and thumbs+viewer folders for both, and builds its
# HEADER.html from its _HEADER.html with a tag replace; this grabs all.
#
# Update [3.0]: Dynamic index layout is now the default, so trnpix's
# fixed variant is now just a demo.  Because it uses fully explicit
# cmd arg configs, there's nothing to adjust for the new layout.
# [3.0] also renamed image files with spaces; use new names here
# (and spaces in filenames cause all sorts of kinipshins in Bash...).
# ========================================================================

# subset of live demo, for viewing code online

trnpix=~/MY-STUFF/Websites/Posts/Current/Complete/trnpix
trnpixcopy=./results-3.0

# doesn't exist or not a dir? [2.2]
if [ ! -d $trnpixcopy ]; then { rm -f $trnpixcopy; mkdir $trnpixcopy; } fi

# regen index+thumbs+viewers: command now in a trnpix subscript (see above)
pushd $trnpix
bash _generate.sh
popd


# copy a small subset of the gallery for online views (bash autosplits strings)

# get core gallery files, prepending a _ ('' retains \)
files="FOOTER.html HEADER.html _HEADER.html \
       index.html index-dynamic.html \
       _generate.sh _publish.sh"
for name in $files
do 
    cp $trnpix/$name $trnpixcopy/_$name
done

# get a sampling of image files
# [3.0] use array instead of string split for embedded spaces
# and quote filename references for spaces too; yikes...

files=("2000 Newmarket 1.jpg" "2001 Dublin 2.jpg" "2018 Galaxy S8+.jpg" "2018 Mobile Site 1.png")

# get .note files: not required for viewing (their text is embedded in .htmls) [2.3]
for name in "${files[@]}"
do 
    cp "$trnpix/$name" "$trnpixcopy"
    if [ -e "$trnpix/$name.note" ]
    then
        cp "$trnpix/$name.note" $trnpixcopy
    fi
done


# copy a sampling of the thumbnail+viewer-page subfolders

subdirs='_thumbspage _thumbspage-dynamic'

for subdir in $subdirs
do
    rm -rf $trnpixcopy/$subdir
    mkdir  $trnpixcopy/$subdir
    for name in "${files[@]}"
    do 
        cp "$trnpix/$subdir/$name"      "$trnpixcopy/$subdir"
        cp "$trnpix/$subdir/$name.html" "$trnpixcopy/$subdir"
    done
done
