#!/bin/bash
# =========================================================================
# Run this bash script in this folder to make just this folder's galleries:
#
#   ~/.../thumbspage/examples/dynamiclayout$ bash _generate.sh
#
# To make all examples, run the script ../../build/generate-examples.py,
# which runs this script and all others like it.  This automates console 
# inputs, but requires a Unix-style bash shell; extrapolate for other 
# shells or run thumbspage manually elsewhere per _HOW-MADE.txt here. 
#
# Unlike examples/trnpix, this does NOT regenerate trnpix's own content,
# but simply copies out its images, header, and footer, and builds its
# own galleries here with commands that differ from those of trnpix.
#
# Update: as of 2.2, this script could use setting=value config arguments
# in its thumbspage command line, instead of editing the config file with 
# a sed command.  The latter is retained here as an example of former
# usage, but also see ahead for an outline of the new 2.2+ alternative.
# See also ../2.2-upgrades/config-args-demo.sh for a comprehensive demo.
#
# Update: as of 2.3, console inputs can be provided with input-override 
# config settings, in the config file or config arguments; see ahead.
# 2.3 also supports popup color configs, but inherit from the page here.
#
# Note: make-narrow-labels.py' enumerate() counter creates unique IDs,
# but includes non-image files that don't show up in the gallery.
#
# Caveat: as coded, the subfolder demos wind up with the hosting site's
# analytics code embedded in them; please don't posts them online verbatim.
#
# Update: the make-narrow-labels.py now copies over and renames 2.3 .note 
# files too, else they would appear in the wide demo only (subtly indeed).
#
# Update: trnpix now builds its HEADER.html twice, by replacing a tag 
# in _HEADER.html; this script will grab the second of the two built.
#
# Update: as of 3.0, dynamic index layout is the preset default, so much 
# of the convolution in this script is no longer required (but remains).
# Better idea: use 2.2+ command-lined argument options and be explicit.
# Also for [3.0], trnpix flenames renamed with spaces, and use grey in 
# the index note in HEADER.htlm so it's not washed out in dark mode.
# ALSO drop update's "background-color: grey;" and "border: black;" for dark 
# theme (bg follows rest of page and border is white in dark and black in light).
# =========================================================================

# Imageless page + 2 subfolder galleries with config edits


#------------------
# Setup and globals
#------------------
 
# drop demo image from prior run, else appears twice!
rm -f Demo-Narrow-Filename-Labels/001.png

# ensure scratch folder
temp=~/Desktop/temp
if [ ! -d $temp ]; then rm -rf $temp; mkdir $temp; fi    # {}; optional, ; or \n

# for script and configs
thumbspage=../..

# for originals only (edit me)
trnpixdir=~/MY-STUFF/Websites/UNION/trnpix

# auto-split in for loops
demos='Demo-Wide-Filename-Labels Demo-Narrow-Filename-Labels'


#-------------------------------
# Copy images in, shorten labels
#-------------------------------

# assumes trnpix images+header+footer are current!
for demo in $demos; do 
    cp $trnpixdir/*.* ./$demo
done

# use py for heavy lifting; .notes too [2.3]
python3 ./make-narrow-labels.py 


#-----------------------------
# Backup and edit configs file
#-----------------------------

##~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
## OR, in 2.2+, use this, and skip the sed edits and config
## save/restore here; the thumbsBgColor index setting now also 
## defaults to lightgrey in 2.2 (no edit or config is needed), 
## and unlike in file, viewerBorderColor doesn't default to Fg:
##
## for demo in $demos; do
##     python3 $thumbspage/thumbspage.py ./$demo \
##         useDynamicIndexLayout=True \
##         viewerBgColor=\'darkgrey\' viewerFgColor=\'black\' \
##         viewerBorderColor=\'black\' <<-EOF
##         ...
##         EOF
##
## OR, in 2.3+, use this, and skip both sed edits and <<-EOF here 
## documents; this new-style build form is generally recommended
## (see Windows for its differences; ^ may be line continuation):
##
## for demo in $demos; do
##     python3 $thumbspage/thumbspage.py ./$demo \
##         useDynamicIndexLayout=True \
##         viewerBgColor=\'darkgrey\' \
##         viewerFgColor=\'black\' \
##         viewerBorderColor=\'black\' \
##         inputCleanThumbsFolder=True \
##         inputThumbMaxSize=100,100 \
##         inputUseViewerPages=True
##~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

# punt: [read -p 'Change user_configs.py to dynamic-layout mode now']
# punt: [sed -i '' -e '...' file] - in-place changes bump modtimes 
# punt: [sed -i 'bkp' -e '...' file] - auto-backups are nonportable?

# save configs file for edits
mv $thumbspage/user_configs.py $thumbspage/user_configs.py.bkp

# make edits to 4 lines: -e 's/from/to/'
# bash: for nested ', use $' \' ' or " ' "

sed -e 's/useDynamicIndexLayout = False/useDynamicIndexLayout = True/' \
    -e "s/thumbsBgColor = '#f5f5f5'/thumbsBgColor = 'lightgrey'/" \
    -e "s/viewerBgColor = 'black'/viewerBgColor = 'darkgrey'/" \
    -e "s/viewerFgColor = 'white'/viewerFgColor = 'black'/" \
	< $thumbspage/user_configs.py.bkp > $thumbspage/user_configs.py


#-----------------------------
# Make root page and galleries
#-----------------------------

# imageless-folder page
python3 $thumbspage/thumbspage.py .

# two subfolder galleries: defaults, no row-size input
for demo in $demos; do
    python3 $thumbspage/thumbspage.py ./$demo <<-EOF



	EOF
done

# restore configs asap
mv $thumbspage/user_configs.py.bkp $thumbspage/user_configs.py


#-------------------------- 
# Fixup gallery index files
#--------------------------

# the galleries need 2 main-site files assumed by trnpix, _main.css
# and a toolbar image, but their toolbar links are also relative to 
# '..' which won't work here; fix all by changing both index's '../'
# to live website links, with in-place sed edits (modtimes okay here)

# cp $trnpixdir/../_main.css .
# cp $trnpixdir/../PythonPowered.gif .

# sed: use @ as alt delimiter
for demo in $demos; do
    sed -i '' \
        -e 's@\.\./@https://learning-python.com/@' \
        $demo/index.html
done


#--------------------------------- 
# Strip full-size images for space
#---------------------------------

# viewer pages won't show images, but this demos indexes only

# but keep one image in each just for show
cp Demo-Narrow-Filename-Labels/001.png $temp
cp Demo-Wide-Filename-Labels/1996\ First\ Pybook.png $temp

# keep index and _thumbspage subddir
for demo in $demos; do 
    mv ./$demo/index.html $temp
    rm ./$demo/*.*
    mv $temp/index.html ./$demo
done

# the first must be removed at start of next run
cp $temp/001.png Demo-Narrow-Filename-Labels
cp $temp/1996\ First\ Pybook.png Demo-Wide-Filename-Labels

