#!/bin/bash
# ========================================================================
# Run this bash script in this folder to make+publish this folder's 
# gallery (only):
#
#   ~/.../thumbspage/examples/3.0-upgrades$ bash _publish.sh
#
# This assumes a Unix-style bash shell; extrapolate for other shells and 
# platforms (e.g., use "py -3" on Windows) or run thumbspage with manual
# console inputs.  To make _all_ thumbspage examples, run the script 
# ../../build/generate-examples.py (run by that folder's _PUBLISH.sh).
# ========================================================================


#-----------------------------------------------------------------
# GENERATE GALLERY LOCALLY
#-----------------------------------------------------------------

bash _generate.sh


#-----------------------------------------------------------------
# MAKE SOURCE CONTENT VIEWABLE
# Copy content to a subfolder viewable on web (sans index.html).
#-----------------------------------------------------------------

# Now in _generate.sh: for own _publish.sh & TP master _PUBLISH.sh.
# Else, _viewable/ can be out of sync if mods made between the two. 


#-----------------------------------------------------------------
# UPLOAD GALLERY TO HOST
# Uses local confgs ($Z, SCP, SSH) that will vary for your devices.
#-----------------------------------------------------------------

# Fix file permissions for web access
find . -type d -exec chmod 755 '{}' \;
find . -type f -exec chmod 644 '{}' \;

# Common defs, aliases, scp/ssh functions with keys (yours will vary)
source ~/MY-STUFF/Websites/_admin/BUILD-THUMBSPAGE-CLIENTS/common.sh

# Zip locally (in examples/ folder)
cd ..
python3 $Z/zip-create.py 3.0-upgrades.zip 3.0-upgrades -skipcruft

# Upload zip to host
SCP 3.0-upgrades.zip htdocs/thumbspage/examples

# Unzip on host
SSH <<-EOF
	cd htdocs/thumbspage/examples
	rm -rf 3.0-upgrades
	unzip -d . 3.0-upgrades.zip
	rm 3.0-upgrades.zip
	exit 
	EOF

# Remove local zip
rm 3.0-upgrades.zip
