#!/bin/bash
# ========================================================================
# Run this bash script in this folder to make this folder's gallery:
#
#   ~/.../thumbspage/examples/3.0-upgrades$ bash _generate.sh
#
# This assumes a Unix-style bash shell; extrapolate for other shells and 
# platforms (e.g., use "py -3" on Windows) or run thumbspage with manual
# console inputs.  To make _all_ thumbspage examples, run the script 
# ../../build/generate-examples.py, which runs this and others like it.
#
# Note that batchnotes.py collects only .note files.  Notes coded in the
# new NOTES.py dictionary are already collected in a single file.
# ========================================================================


#------------------------------------------------------------------
# BATCH NOTES
# Runs note batcher in '.' for spellcheck.  Makes _batchnotes.txt.
#------------------------------------------------------------------

python3 ../../docetc/batchnotes.py


#------------------------------------------------------------------
# BUILD GALLERY
# This folder ('.') with images, header, notes, captions, ordering.
#------------------------------------------------------------------

python3 ../../thumbspage.py . \
        useEndOfGalleryPage=True \
        dynamicLayoutPaddingH=\'8px\' \
        inputCleanThumbsFolder=True \
        inputThumbMaxSize=128 \
        inputUseViewerPages=True


#------------------------------------------------------------------
# MAKE SOURCE CONTENT VIEWABLE
# Copy content to a subfolder viewable on web (sans index.html).
#------------------------------------------------------------------

# This step is needed only for code presentation on TP's host website.
# Done here so it runs for both own _publish.sh and TP's master _PUBLISH.sh.
# _htaccess, copied to _viewable/.htaccess, shows .html files as plain text.

# Create _viewable subfolder with all source content, renaming some
echo "Making viewable folder"
rm -rf _viewable
mkdir _viewable
cp -R -p *.txt *.sh *.html _htaccess _thumbspage* \
    *.jpg *.JPG *.png *.gif \
    *.note *.py *.original _viewable
mv _viewable/index.html _viewable/_index.html 
cp -p _htaccess _viewable/.htaccess


#------------------------------------------------------------------
# PUBLISH GALLERY FOLDER
# Copy locally, or zip and upload/unzip on host device as needed.
#------------------------------------------------------------------

# See _publish.sh for an automated example of these steps.
