#!/bin/bash
# ========================================================================
# Run this Bash script in this folder to make just this folder's gallery:
#
# .../thumbspage/examples/2.2-upgrades/tool-tips-gallery$ bash _generate.sh
#
# To make all examples, run the script ../../build/generate-examples.py,
# which runs this script and all others like it.  This automates console 
# inputs with <<-EOF 'here' documents, but requires a Unix-style Bash shell;
# extrapolate for other shells or run thumbspage manually elsewhere. 
#
# Also demos 2.2 command-line config arguments for customization.
# See also ../more-demos/config-args-demo.sh for a similar demo.
#
# Update: as of 2.3, console inputs can be more portably provided as 
# setting=value command-line config arguments too, instead of using the
# <<-EOF "here documents" technique shown here.  See UserGuide.html#2.3.
# ========================================================================

# Custom layout, tool tips, separation (see also 2.1's dynamiclayout/);
# thumbsBgColor=\'lightgrey\' is not needed: the default preset in 2.2;
# dynamicLayoutPaddingH=\'0px\' shrinks separators, despite label width;


python3 ../../../thumbspage.py . \
	useDynamicIndexLayout=True \
	dynamicLayoutPaddingH=\'0px\' \
	useToolTips=True \
	<<-EOF

	128,128

	EOF
