"""
================================================================================
user_configs.py, part of thumbspage [added in 1.6, expanded later]

Change the Python-coded default settings here to configure thumbspage results. 

These are lesser-used options, beyond per-run console inputs, but easier to 
tailor than custom HTML.  For more advanced customizations, the index page 
can also be customized with HEADER.html and FOOTER.html insert files, and the 
viewer-page template file can be edited freely (but may be best left intact).

For example, a HEADER.html can code a custom message, whole-page font, and 
thumbs-table font for the index page.  Include CSS style blocks to set fonts:
- <style>body {font-family: Arial;}</style> for the whole page
- <style>td {font-style: italic;}</style> for just labels in fixed layout
- <style>#thumbslinks {font-weight: bold;}</style> for labels in dynamic layout

See the examples/ folder here for HEADER.html and other usage examples,
and consult UserGuide.html#Customization for more on advanced techniques.
Programmers, for example, might be interested in search-and-replace tags.

General usage notes:
- When upgrading, be careful to save and reinstall your edits to this file.
- If needed, there is a backup copy of this file's shipped version in docetc/. 
- Most newer settings appear later in this file, but search by release #s too.
- Always use Python's True and False here, not JavaScript's true and false.

Update: as of version 2.2, config settings in this file can be overridden on 
a per-build basis with command-line arguments of the form "setting=value".  
See UserGuide.html#configcmdargs22 for complete coverage of this alternative.
Args are applied after this file is imported, and cannot name other settings.

Update: as of 2.3, this file and command arguments can also provide values
normally input in the console.  Precedence: argument, then here, then input
(i.e., arguments override settings here, and inputs are tried iff no other).
Special: if the first command arg is image folder, it overrides all others.
================================================================================
"""



#-------------------------------------------------------------------------------
# Output folder/file names
#-------------------------------------------------------------------------------
# THUMBS is the name of a subfolder within the image folder, where both
# thumbnail images and viewer pages are stored.  INDEX is the name of the
# index page created in the image folder; ".html" is appended automatically.
# THUMBS should start with a "_" or "." to omit it from index-page subfolder 
# lists, and is also used for the limited GUI-mode viewer's folder as of 2.1.
# Viewer pages in THUMBS always open ../INDEX.html on Index-button taps.
#-------------------------------------------------------------------------------

THUMBS = '_thumbspage'              # built subfolder name (thumbs+viewers)
INDEX  = 'index'                    # built index-page name ('default'?, 'home'?)



#-------------------------------------------------------------------------------
# Code-generation options: index page
#-------------------------------------------------------------------------------
# Assorted settings added in assorted releases (mostly in [1.5] and earlier). 
# These mostly pertain to the index page; viewer pages use an editable template.
# uniformColumns is not used if 2.1's dynamic layout option is enabled ahead.
#-------------------------------------------------------------------------------

# Fixed-layout index
uniformColumns = True               # same-width columns? (else by content)

# Auto subfolder-links list
listSubfolders  = True              # show folder-links list? (or do via header)
subfolderSpacer = '7px'             # CSS space between folder links, 6px->7px [2.1]

# Assorted additions
useViewPort   = True                # add mobile-friendly viewport?
caseSensOrder = True                # index/nav order is case sensitive?

# Defunct: always on as of [1.5], for fixed-layout table borders
# spanFullWindow = False            # stretch table to window's width?



#-------------------------------------------------------------------------------
# Colors: index- and viewer-page background, foreground, etc. (also Top ahead)
#-------------------------------------------------------------------------------
# Set Border=Bg color to omit index image borders.  Use any web color name or 
# a #RRGGBB hex string (e.g., 'ivory', '#633025' (a brown), '#008080' (a teal)).
# These settings were added across versions [1.5] and [1.6], though all were 
# new in [1.6] except the Bg colors, and [2.0] extended viewer colors to info.
#
# [2.2] preset thumbsBgColor slightly darker for contrast: #f5f5f5 => lightgrey;
# for something in between the old and the new, try #eeeeee or similar.
#
# [2.3] add popup*Color for info and Note popup dialogs in viewer pages;
# if None (preset), these inherit the viewer* page-wide settings as before; 
# else, they apply to both info and Note popups; subtlety: popup OK buttons 
# use the popup border setting here, but for symmetry always take their bg/fg
# colors from the page, not the popup; see also UserGuide.html#popupcolors23.
#
# [2.3] add popupOpacity for dimness of background when popups appear; brighter
# (lower) is good when notes reference images, but darker (higher) may be better
# when notes are longer or images are very bright and may clash with notes.
# The preset 0.40 means 40% opaque, the same as in prior thumbspage versions.  
#-------------------------------------------------------------------------------

# Index page:

thumbsBgColor = 'lightgrey'         # thumbs page table background color ([2.2])
thumbsFgColor = 'black'             # thumbs page table foreground: filename
thumbsBorderColor = thumbsFgColor   # index-page thumbnail border color (=Fg?)

# Image-viewer pages (and formerly, their info popups [2.0])

viewerBgColor = 'black'             # viewer pages background color
viewerFgColor = 'white'             # viewer pages foreground: filename, buttons
viewerJSColor = 'red'               # no-JavaScript note text color
viewerBorderColor = viewerFgColor   # viewer-page image border color (=Fg?)

# Viewer-page info _and_ note popups (note + these settings [2.3])

popupBgColor = None                 # box    (None = use viewerBgColor; else 'darkgrey'?)
popupFgColor = None                 # text   (None = use viewerFgColor; else '#dddddd'?)
popupBorderColor = None             # border (None = use viewerBorderColor; else '#222'?)

# Viewer-page: opacity (dimness) of background for info and Note popup overlays [2.3]

popupOpacity = 0.40                 # higher = dimmer (darker) background (0.0..1.0)
 
# See also Top button colors ahead



#-------------------------------------------------------------------------------
# Stretch smaller images beyond actual size on viewer pages? [1.6]
#-------------------------------------------------------------------------------
# If True, this expands images smaller than the display to fill all 
# viewer-page space.  This works, but it can make small images blurry.
#-------------------------------------------------------------------------------

expandSmallImages = False           # True = show larger, but may be blurry



#-------------------------------------------------------------------------------
# Unicode text-file settings (generally best unchanged) [1.6]
#-------------------------------------------------------------------------------
# insertEncoding 
#     Used for loading index-page header/footer insert files.
#     None=default platform encoding; 'UTF-8' also handles ASCII.
#     The generated index page is encoded per outputEncoding.
#
# outputEncoding
#     Used for all generated page content, and default HTML <meta> tags.
#     Use a real encoding name (not None); 'UTF-8' works for all text.
#     Not used for URL encoding: this is always UTF-8 (see url_escape()).
#     Encoding in a HEADER.html <meta> tag should match outputEncoding.
#
# templateEncoding
#     Used for loading the viewer-page template file, "template-viewpage.html".
#     The resulting viewer pages generated are encoded per outputEncoding.
#
#     [2.0] templateEncoding is now also used to load the floating Top button's 
#     "template-floatingtop.html" (added to index pages per outputEncoding).
#
# noteEncoding
#     [2.3] Used for loading ".note" Note text files (see useImageNotes ahead).
#-------------------------------------------------------------------------------

insertEncoding   = 'UTF-8'          # index-page header/footer files
outputEncoding   = 'UTF-8'          # used for all generated pages 
templateEncoding = 'UTF-8'          # viewer-page+Top template files [2.0]
noteEncoding     = 'UTF-8'          # imagename.note Note text files [2.3]



#-------------------------------------------------------------------------------
# Turn off disable for image-history destacking for Chrome on iOS (temp) [1.6]
#-------------------------------------------------------------------------------
# Chrome on iOS (only) has a bug in its location.replace(), which requires
# disabling thumbspage's viewer-page history destacking feature in this browser 
# alone.  Set to True if ever fixed.  See 1.6 notes in UserGuide and JS code.
# Update: still broken in May 2020's iOS Chrome 75; True here stacks all pages.
#
# Update: iOS Chrome's behavior is not fixed, but is now no different than the 
# work-around; default to True here to skip the work-around.  Navigation pages
# will be stacked on iOS Chrome until it's fixed (or this switch is changed). 
#
# Update: this iOS Chrome history bug was eventually fixed, as of Chrome 83
# in June 2020 (and perhaps earlier).  The True setting below adopts the fix,
# which no longer stacks navigation pages in browser history--as intended.
#-------------------------------------------------------------------------------

chromeiOSBackFixed = True           # True = stop disabling the work-around



#-------------------------------------------------------------------------------
# Automatic right-side up image and thumbnail orientation (best unchanged) [1.6]
#-------------------------------------------------------------------------------
# If autoRotateImages is True, images and their thumbnails are automatically 
# rotated as needed to display their top side on top.  If backupRotatedImages
# is True, any rotated images are saved to backup copies in the images folder
# with ".original" extensions before any changes are made.  To restore originals
# from backups, run "docetc/restore-prerotate-originals.py".  Auto-rotation 
# works only for some image types and cameras/tools, and is just an automatic
# alternative to manually rotating tilted images before running thumbspage.
#
# [2.1] thumbspage now automatically deletes embedded thumbnail images on
# rotations by default, because these were not adjusted for rotations and
# could cause issues in other tools (e.g., some file explorers displayed 
# skewed thumbnails for images recorded on some devices).  The deletion is 
# generally harmless: embedded thumbnails are not used by thumbspage, and 
# other tools simply fall back on their handling for images that never had 
# embedded thumbs in the first place.  If you're sure this isn't a concern
# for your images, you can set deleteEmbeddedThumbs to False to avoid the
# removal.  If you do, originals, including their embedded thumbnails, can
# be restored from ".original" backups if tools ever skew thumbs of rotated
# images.  For more: examples/console-logs/2.1-embedded-thumbs-removal.txt.
#-------------------------------------------------------------------------------

autoRotateImages     = True          # False = no auto rotations attempted
backupRotatedImages  = True          # False = no ".original" backup copies
deleteEmbeddedThumbs = True          # False = retain embedded thumbnails [2.1]



#-------------------------------------------------------------------------------
# Use pre-1.7 CSS-based display, not JS scaling, for iOS Safari landscape [1.7]
#-------------------------------------------------------------------------------
# As of 1.7, thumbspage uses JavaScript image scaling for landscape orientation
# in all browsers.  This works well everywhere, including iOS Safari as long as 
# users enable the toolbar-hiding option added in iOS 13.  On devices not using
# the iOS 13 option, the landscape scaled display requires a minor scroll in 
# Safari, but is better than the former CSS-based scaling.  For compatibility,
# a True here reenables the pre-1.7 CSS-based landscape display for iOS Safari.
#-------------------------------------------------------------------------------

iOSSafariLandscapeCSS = False       # True = use former legacy display



#-------------------------------------------------------------------------------
# Don't upscale/boost index-page text in iOS Safari landscape orientation [1.7]
#-------------------------------------------------------------------------------
# As of 1.7, thumbspage emits a "-webkit-text-size-adjust" style in default 
# thumbnail index pages, to disable iOS Safari upscaling (a.k.a. size boosting)
# for some text in landscape orientation.  This allows more text to be viewed, 
# and is new in index-page default headers only.  To restore prior behavior, 
# use either False below, or a custom HEADER.html file without the new style.
#-------------------------------------------------------------------------------

noiOSIndexTextBoost = True          # False = upscale index-page text



#-------------------------------------------------------------------------------
# Per-gallery delay between image-viewer pages for automatic slideshows [2.0]
#-------------------------------------------------------------------------------
# As of 2.0, thumbspage image-viewer pages implement an automatic slideshow 
# that advances to the next image after a fixed delay.  The delay cannot be
# changed by gallery users, but can vary per generated gallery: set it here
# before build, with a milliseconds-delay value (e.g., 3000 is 3 seconds, 
# and 100 is fun but probably too fast for anything but a strobe light).
#
# Note: the previous/next buttons work during, and do not cancel, slideshows
# in progress; the slideshow toggle and most gallery exits cancel slideshows.
#
# [2.1] The preset delay was changed from 5 seconds to 4 here initially, but 
# changed back to 5 seconds (5000 msecs) late in the 2.1 project.  This is a
# delicate tradeoff: longer delays seem better for galleries not yet seen; 
# shorter works well for revisits and avoids seeming stuck when a show first 
# starts; but too short can appear chaotic (and 4 seconds seemed to qualify). 
# Your galleries may vary, and users can always tap Auto to pause on an image. 
#-------------------------------------------------------------------------------

autoSlideShowDelayMS = 5000     # milliseconds between pages in slideshows



#-------------------------------------------------------------------------------
# Disable or configure the floating "Top" button displayed on index pages [2.0]
#-------------------------------------------------------------------------------
# As of 2.0, thumbspage generates index-page code to display a floating
# Top button that jumps to page top when clicked/tapped.  This is intended 
# for larger indexes that have useful content at page top, and is more useful
# on mobile than desktop browsers to minimize scrolls.  Settings here can omit 
# the button in a given gallery, tailor the scroll location at which it first
# appears, and specify its distance from page bottom to allow for toolbars.
# For background and foreground colors, use any web name or #RRGGBB hex string. 
#
# Note: when using a custom FOOTER.html, you may need to add margin spacing
# below its last content line, to prevent the Top button from covering it
# (e.g., <P style="margin-bottom: 80px;"> - see template-floatingtop.html).
#-------------------------------------------------------------------------------

floatingTopEnabled    = True    # True = emit code for floating Top
floatingTopAppearAt   = 500     # show Top when scroll to this pixel offset+
floatingTopSpaceBelow = 36      # Top's pixel offset from page bottom

floatingTopFgColor = 'white'    # foreground: any 'name' or '#RRGGGBB' hex string
floatingTopBgColor = '#999'     # which is #999999, which is rgb(153, 153, 153): grey



#-------------------------------------------------------------------------------
# Enable Full fullscreen toggle button in image-viewer toolbars (limited) [2.0]
#-------------------------------------------------------------------------------
# As of 2.0, thumbspage viewer page toolbars can optionally have a Full button
# which toggles fullscreen display on and off for that page - only.  Because
# this lasts for just one page and is unsupported on some platforms (e.g., iOS),
# this feature can be disabled here (it's on by default as a demo).  Users can 
# manually enable a fullscreen mode in some browsers that spans pages (e.g., all
# pages visited during an Auto slideshow); see UserGuide.html#fullscreenmanual.
#-------------------------------------------------------------------------------

showFullscreenButton = True     # True = show Full button on viewer pages



#-------------------------------------------------------------------------------
# Thumbnail auto and/or manual enhancements, drop noise and blur as preset [2.1]
#-------------------------------------------------------------------------------
# As of 2.1, the following settings can be used to customize enhancements for
# generated thumbnail images.  Both three precoded (auto) and five arbitrary 
# (manual) settings are available; you can freely use zero or more from each 
# set below, though some auto settings are redundant with some manual settings
# (e.g., you probably want to disable auto sharpen when using manual sharpen).
#
# As shipped, the True preset defaults below (1) increase save quality to 
# avoid minor loss/noise in some JPEG thumbs, which stems from compression,
# and is most noticeable at higher browser zooms; and (2) sharpen all thumbs 
# by a fixed amount to negate the blurring that's inherent in the underlying 
# image library's thumbnail resizes, even for its best resampling filter.  
# Both of these preset enhancements improve thumbnail appearance noticeably
# in all galleries and on all displays tested.
#
# The presets can also increase the space required for thumbs, but only by a 
# trivial amount: for an example 112-image gallery, thumbnail folders (HTML 
# files + images) take up 6M with no enhancements or just sharpening; 6.6M 
# with just higher quality; and 6.7M with boosted quality and sharpening.  
# The space used by all thumbnail images alone is only around 1M in all cases.
# Sharpening can also yield rare and minor noise in some images at higher 
# browser zooms, but its extra clarity seems well worth its tradeoffs.
#
# Still, if the presets' space or noise tradeoffs prove unwanted for your use
# case, turn off the autos, and set manual options instead as desired.  Simply  
# changing the two presets from True to False, for instance, restores 2.0 
# thumbnails.  For more details on the underlying library's usage of manual 
# factors, either experiment with values, or see the image library's docs:
#
# https://pillow.readthedocs.io/en/stable/
#     reference/ImageEnhance.html?highlight=ImageEnhance
# https://pillow.readthedocs.io/en/stable/
#     handbook/image-file-formats.html?highlight=quality
#
# The auto quality and sharpen options, for example, use 100 and 2 for the
# corresponding manual factors, but manual factors support ranges of values.
# Quality is applied on saves; all others are applied to thumbs in memory.
#
# Caveat: in 2021, sharpness doesn't seem to help WebP and some GIFs; YMMV.
# Tip: when in doubt, try it out; the impacts of these can vary per gallery.
#-------------------------------------------------------------------------------


# AUTO enhancements: precoded common changes, use one or more.
# The first two are preset to True to remove JPEG noise and sharpen all thumbs;
# they should probably stay True unless they cause issues in your galleries.

thumbsAutoHighQuality = True           # True = no JPEG compression noise (default)
thumbsAutoSharpen     = True           # True = all images are less blurry (default) 
thumbsAutoBlackWhite  = False          # True = remove all color (precoded b&w mode)


# MANUAL enhancements: use one or more instead of or in addition to autos.
# In all five:  None=ignore, number=apply (integer or float).
# In the last four: 1.0=original, < 1.0 is less, > 1.0 is more.

thumbsManualQualityFactor    = None    # 0 (worst)..100 (best), None=default=75 (jpeg)
thumbsManualSharpnessFactor  = None    # 0.0=blur, 1.0=original, 2.0=sharpen, >2=sharper
thumbsManualContrastFactor   = None    # 0.0=solid grey,  1.0=original, >1.0=vivid
thumbsManualColorFactor      = None    # 0.0=black&white, 1.0=original, >1.0=saturated
thumbsManualBrightnessFactor = None    # 0.0=black, 1.0=original, >1.0=brighter



#-------------------------------------------------------------------------------
# Dynamic index-page layout for thumbnail links (optional, experimental) [2.1]
#-------------------------------------------------------------------------------
# As of 2.1, thumbspage provides two ways to layout the thumbnail links on index
# pages: (1) the original fixed model, which renders a preset number of columns 
# in all contexts, and (2) a new dynamic model, which arranges thumbnail
# columns to match page size, and rearranges them on page resizes.  
# 
# The new dynamic mode uses available space well on desktop browsers and avoids 
# some minor horizontal scrolling on mobile, but can be less than ideal on 
# mobile: phones may display a single long column, which can require much more 
# vertical scrolling, and much more navigation work overall.  
#
# Because of this, and other tradeoffs discussed in the User Guide's 2.1 note,
# the new dynamic layout is an experimental alternative in 2.1.  To enable it 
# for your galleries, set the first switch below to True; its False preset 
# selects the original and still default fixed-layout scheme.
#
# If you opt to enable dynamic layout, you can also customize the amount
# of padding space around each thumbnail, with the other two settings here:
# PaddingH is horizontal (left+right) and PaddingV is vertical (above+below).
# Both are cumulative: '8px' means 8 pixels on both sides, and for each cell.
# Use any CSS size unit (e.g., '0px', '8px', '1em').  Smaller values squeeze 
# thumbs closer together, and larger spreads them out more.  Padding here is 
# is always applied to cells, though the horizontal spacing also depends on 
# how wide your gallery's image-filename labels are compared to its thumbnails: 
# filename labels dominate the horizontal layout if wider than thumbnail images.
#
# [2.3] The dynamic horizontal layout scheme now packs columns closer 
# together when labels are wider than images.  This render more than one 
# column for some galleries on some mobiles.  The default presets here were
# unchanged, but can be freely decreased for tighter fit, or increased to 
# compensate for undersizing.  See UserGuide.html#dynamiclayout23.
#
# [2.3] If you omit filename labels with omitIndexPageLabels ahead, the 
# two padding settings here allow you to space out thumbnails better.  A 
# '16px' for both is recommended, but may be subpar if labels are present.
#-------------------------------------------------------------------------------

useDynamicIndexLayout = False    # True = dynamic layout, False = fixed layout

dynamicLayoutPaddingH = '8px'    # horizontal space around thumbs (0px=close)
dynamicLayoutPaddingV = '15px'   # vertical space around thumbs   (32px=distant)



#-------------------------------------------------------------------------------
# Touch: meaning of left/right swipes for touch gestures [2.2]
#-------------------------------------------------------------------------------
# As of 2.2, image-viewer pages support left/right and up/down gestures in the
# image-display area (not the entire page) on touch displays.  Up/down invoke 
# the info dialog and raw image view, respectively.  Left/right move to the 
# previous or next image in the gallery, per the following setting's value: 
#
# If True:  left=Prev, right=Next
#           matches the Prev/Next buttons on the toolbar
#
# If False: left=Next, right=Prev
#           uses the opposite and common "natural" order (and is default)
#
# Swipes are just alternatives to taps on widgets, and work on mobiles and PCs.
# Widget taps still work as before, including taps on images for raw views.
#-------------------------------------------------------------------------------

lrSwipesPerButtons = False    # swipe left/right in direction of Prev/Next buttons?



#-------------------------------------------------------------------------------
# Touch: enable up-swipe in browsers that didn't formerly support it? [2.2]
#-------------------------------------------------------------------------------
# As of 2.2, up-swipe is implemented only for Firefox on Android and Windows,
# all browsers on iOS, and Samsung Browser on Android.  Other browser and 
# platform combos, most notably Chrome and its Edge and Opera relatives on 
# Android and Windows, have a glitch which makes it impossible to return to 
# the gallery's image-viewer page with Back after an up-swipe to raw view. 
#
# Because Chrome has history of fixing bugs (see chromeiOSBackFixed earlier in
# this file), you can set the following switch to True to both test if this
# bug has been fixed, and enable up-swipe on all browsers.  thumbspage may be
# rereleased for such a fix, but this switch can accommodate it earlier.
# See UserGuide.html#chromeupswipebug22 for more info on the glitch.
#
# [2.3] UPDATE: This setting is now IGNORED if useImageNotes (below) is True
# and any ".note" files exist.  If so, up-swipe is now always the same as a 
# tap on the new Notes button, and opens the image's text note, if it has one.
# Else, up-swipe is raw view as in 2.2 (with the same browser-specific	quirks). 
#-------------------------------------------------------------------------------

upSwipeOnAllBrowsers = False    # has Chrome fixed its Back-after-Up bug yet?



#-------------------------------------------------------------------------------
# Tooltip hover popups [2.2]
#-------------------------------------------------------------------------------
# If and only if the following setting is True, both index and viewer pages 
# will include "title" attributes, which trigger a tooltip text popup when
# a mouse hovers over an image (on index and viewer pages), and filename and
# Auto and Full buttons (on viewer pages).  Tooltips don't appear on mobile, 
# and their text is short (e.g., "View image") but they may be distracting and 
# pointless after some use.  Hence, they're off as preset; enable with True.
#
# [2.3] Changed to be ENABLED per default preset; with the new Note button,
# viewer pages have grown complex enough to warrant the tips (where supported).
# There now are also tooltips on the Prev/Next/Index buttons for consistency.
#-------------------------------------------------------------------------------

useToolTips = True    # add 'title' attributes for tooltip hover popups?



#-------------------------------------------------------------------------------
# Default-footer tagline visibility [2.2]
#-------------------------------------------------------------------------------
# Index pages that are not built with a custom FOOTER.html file have always 
# included a brief tagline at the end (e.g., "Gallery built by thumbspage.py" or
# "Page built by thumbspage.py"), with a link to this program's web page.  As  
# this is a mild form of advertising, the tagline can now be omitted by setting
# the following switch to False.  It can also be omitted by using a basic custom
# footer as before; this is just an automated scheme for default-footer pages.
#-------------------------------------------------------------------------------

defaultFooterTagline = True    # thumbspage plug at end of default pages?



#-------------------------------------------------------------------------------
# Note button + display for viewer pages [2.3]
#-------------------------------------------------------------------------------
# Text notes allow you to provide plain-text descriptions for some or all 
# of the images in your galleries.  The useImageNotes setting below, or its 
# command-line argument equivalent, enables this as follows:
#
# If useImageNotes is False OR no images have .note files:
#     - No Note buttons are displayed in viewer-page toolbars
#     - Any .note files in the images folder are ignored
#     - Up-swipes work as they did in 2.2, opening raw-image views
#
# If useImageNotes is True AND any image has a .note file:
#     For images with a .note file:
#         - The viewer page shows a Note button with normal font and color
#         - Note taps pop up the .note file's content as plain text
#         - Up-swipes also open the note file's content, not raw-image views    
#     For images without a .note file:
#         - The viewer page still shows a Note button, but with line-through
#         - Note taps and up-swipes work, but show default text "(No note)"
#
# How to code notes:
#
# To code a note for an image, create a text file with a ".note" extension 
# in the main images folder, alongside the image itself.  For example, make
# "images/photo.jpg.note" to give the Note text for "images/photo.jpg".  
#
# The popup collapses all text in the ".note" file into a single paragraph, 
# except that an empty line (i.e., two adjacent line breaks, '\n\n') is 
# treated as a paragraph break in the popup, and renders as a blank line.  
#
# Any Unicode character can appear in the file, including emojis.  Both
# HTML and JavaScript special characters can be used freely; they do not
# impact the note's text, and render literally as given (e.g., "<A>" does 
# not produce a link, and quotes and backslashes do not modify text).
# Notes scroll vertically if too tall, but should be short as a guideline.
#
# Special cases:
#
# If there are no ".note" files in the images folder at build time, this
# feature is automatically disabled by the system for the gallery build.
# This avoids showing Note buttons on viewer pages which would all be no-ops.
# Hence, useImageNotes is used only if at least one ".note" file exists.
#
# If this feature is enabled, up-swipe on touch screens is the same as tapping
# a Note button, and opens the note; use image taps for raw-image views.
# Notes don't stay up during Auto slideshows, as images would be obscured.
# Related: see also noteEncoding and upSwipeOnAllBrowsers settings above.
#
# Also here: noteBoxVSpace defines how much empty space appears to the left
# and right of the note box.  The preset 15% makes the box fill 70% of the 
# page (100% - (15% * 3)), and is a reasonable compromise between mobile 
# (where larger is better) and desktop (where the box expands and shrinks
# with the window).  Use smaller settings for wider notes on mobile, and
# any size type (e.g., arg noteBoxVSpace=\'10%\', here noteBoxVSpace='5px').
#
# See also: popup*Color settings above for Note (and info) box background,
# foreground (text), and border colors.  They still inherit from the viewer 
# page as preset, but can now be tailored to vary from the enclosing page.
# The original white on black may be difficult to read on some displays.
#-------------------------------------------------------------------------------

useImageNotes = True    # True: show Note button and make up-swipe==Note, if "*.note"
noteBoxVSpace = '15%'   # space on left and right of popup: 15% leaves 70% for box 

# Plus noteEncoding .note Unicode setting earlier in this file

# Plus popup* bg/fg/bd/opacity color settings earlier in this file



#-------------------------------------------------------------------------------
# Console-input overrides: via configs, here or in command-line args [2.3]
#-------------------------------------------------------------------------------
# The following settings correspond to inputs requested interactively at the 
# console in all prior releases.  If any are not None, their value is used for
# the input, and the input is not requested in the console.  If None, their
# values are asked as before.  All are preset to None here, to ask by default.
#
# With 2.2, console inputs became arguably redundant with build-command config
# arguments.  The settings here allow inputs to be provided either here or in 
# "setting=value" config arguments in a backward-compatible fashion, and can 
# avoid some former "<<EOF" shell antics used to precode inputs.
#
# Note that inputThumbsPerRow is never asked when dynamic layout it enabled 
# (see useDynamicIndexLayout above), and inputImagesFolderPath is never asked
# when the image folder's path is passed in as the first command argument.
#
# Image-folder path can be provided by first arg, name=value config arg, here,
# or console input - and that order is also the precedence (first arg highest).
# The precedence for others is the same, but without the first-arg component.
#
# Command examples:
#
# Folder in first arg, dynamic layout, input others not set here:
#   $ python3 $C/thumbspage/thumbspage.py . useDynamicIndexLayout=True 
#
# Folder in first arg, dynamic layout, all other inputs via args
#   $ python3 $C/thumbspage/thumbspage.py . useDynamicIndexLayout=True \
#       inputUseViewerPages=True inputThumbMaxSize=128,128 inputCleanThumbsFolder=True
#
# Folder via config arg, fixed layout, others via settings here else inputs
#   $ python3 $C/thumbspage/thumbspage.py inputImagesFolderPath=\'.\'
#
# Special case: inputThumbMaxSize can be either a 2-tuple of integers or a
# single integer, when provided by this config.  If it's a single integer, it
# is treated the same as a 2-tuple of the same value: X is the same as (X, X),
# which yields square bounds and is the normal use case.  This value must 
# still be a tuple only when it is provided as a console input.  Use a full
# tuple here in the unlikely event that the width and height should differ;
# else, these config forms are equivalent:
#
#     inputThumbMaxSize=128
#     inputThumbMaxSize=128,128
#-------------------------------------------------------------------------------

# None=ask, else use value and don't ask

inputImagesFolderPath  = None    # string 'path' (iff not first argument)
inputCleanThumbsFolder = None    # True or False
inputThumbsPerRow      = None    # integer (used iff not useDynamicIndexLayout)
inputThumbMaxSize      = None    # 2-tuple of ints, or int (inputThumbMaxSize=128)
inputUseViewerPages    = None    # True or False (inputUseViewerPages=True)



#-------------------------------------------------------------------------------
# Thumbs-only index pages: don't show filename labels [2.3]
#-------------------------------------------------------------------------------
# If the following is True, the index page will display only thumbnail 
# images, not their filename labels.  This might be useful when thumbs
# alone are enough, or viewer-page Note popups provide ample description.
# It also deviates from the folder-view paradigm, and deprives viewers of
# potentially descriptive filenames.  Your gallery mileage may vary.
#
# Note: this works for both fixed and dynamic index-page layouts, but
# you'll probably want to also use dynamicLayoutPaddingH/V above in 
# dynamic layout, to spread thumbs out more than their defaults. 
# Fixed layout doesn't allow spacing to be tweaked, but automatically 
# sets it to accommodate its resizing table and avoid thumb collisions.
#-------------------------------------------------------------------------------

omitIndexPageLabels = False      # True=thumbnail images only, False=thumb+label

# Plus dynamicLayoutPaddingH/V for dynamic-layout spacing (e.g., '16px')



# [end]
