#!/usr/bin/env python3
"""
===========================================================================
restore-prerotate-originals.py, part of the thumbspage system [1.6].
See thumbspage.py for copyright, author, and license.

This moves all ".original" image backup copies to their original names.
These backups are created for tilted images before they are rotated to
be right-side up for in-page gallery display, and before any embedded 
thumbnails are removed to avoid skew in some tools (e.g., file explorers).

Run this script with no arguments in the images folder having backups 
to be restored; it restores originals in the current working directory.
Assuming $C is the folder where thumbspage's code is installed:

  some/folder$ cd imagefolder
  imagefolder$ python3 $C/thumbspage/docetc/restore-prerotate-originals.py 
  Moved sonydsc-6R.JPG.original to sonydsc-6R.JPG
  Moved ipod6g-8L.JPG.original to ipod6g-8L.JPG
  Moved galaxys8-8L.jpg.original to galaxys8-8L.jpg
  ...etc...
===========================================================================
"""

import os, glob

# restore all backups in '.'
for copyname in glob.glob('*.original'):

    sourcename = os.path.splitext(copyname)[0]    # sans .original
    os.replace(copyname, sourcename)

    print('Moved', copyname, 'to', sourcename) 
