#!/bin/bash
#=======================================================================
# Build/publish all thumbspage external examples in site automatically.
# Run after global thumbspage gallery changes to update all dependents.
#
# Run me anywhere, no arguments: cds as needed using absolute paths.
# For each client, generates galleries, zips, uploads, and unzips on
# server, inserting analytics and performing any demo-specific steps.
#
# UPDATE: some of the version of this code used in production is now
# included in folder x-publish-external-demos-prod/, though you'll 
# have to extrapolate from _publish.sh file names to folder locations.
# 
# PLEASE NOTE: this version of this script works, but is not used as 
# is in production, and is provided here as a thumbspage example only.  
#
# This script is hardcoded for the hosting site, and will not work 
# for others.  Moreover, this is a simplified excerpt of the site's 
# build system.  In the actual site, this file's steps are split off 
# to separate scripts in individual client folders, to better support 
# single-part builds (much like the per-folder _generate.sh scripts in 
# generate-examples.py).  The subfolder scripts source common setup 
# code, and this script is just a top-level controller.  All that 
# said, you may find the excerpt here useful as an example anyhow.
##=======================================================================


#----------------------------------------------------------------------
# setup code
#----------------------------------------------------------------------

echo 'External builds starting at:' $(date)

shopt -s expand_aliases    # for py3 if noninteractive
alias py3=python3

Z=~/MY-STUFF/Code/ziptools/link
W=~/MY-STUFF/Websites
C=~/MY-STUFF/Code
M=$C/thumbspage/build

stamp=$(date +%b-%d-%y)

# ensure scratch folder
temp=~/Desktop/temp
if [ ! -d $temp ]; then { rm -f $temp; mkdir $temp; } fi

# stop for enter or ctrl-c between steps (y or not)?
Pause=y

function announce { 
    echo
    printf '@%.0s' {1..60}; echo    # py '@'*60
    echo STARTING: $1
    if [ $Pause == 'y' ]; then 
        read -p 'Press enter/return to continue' 
    fi
    printf '@%.0s' {1..60}; echo
}

# uploads and remote unzips
sshusr=bitnami@44.232.137.139
sshkey=$W/_admin/SSH-private-key-download/LightsailDefaultKey-us-west-2.pem

function SCP { scp -i $sshkey $1 $sshusr:$2; }    # pass from, to
function SSH { ssh -i $sshkey $sshusr; }          # pass here doc of cmds
 
# or: SSH="ssh -i $sshkey $sshusr" + $SSH (use "" to eval nested vars)


#----------------------------------------------------------------------
announce trnpix
#----------------------------------------------------------------------

cd $W/Posts/Current/Complete
py3 $C/thumbspage/thumbspage.py trnpix <<-EOF
	
	
	
	
	EOF

# already has, but may change
py3 $M/insert-analytics.py trnpix/index.html

cd $W
py3 _PUBLISH.py | tail -n 20

cd UNION
py3 $Z/zip-create.py trnpix.zip trnpix -skipcruft | tail -n 20

SCP trnpix.zip htdocs
SSH <<-EOF
	cd htdocs
	rm -rf trnpix
	unzip -d . trnpix.zip
	rm trnpix.zip
	exit 
	EOF

mv trnpix.zip $C/thumbspage/_private/trnpix--$stamp.zip


#----------------------------------------------------------------------
announce gadgets
#----------------------------------------------------------------------
 
cd $W/Programs/Current/Complete
py3 $C/thumbspage/thumbspage.py gadgets <<-EOF
	
	
	
	
	EOF

# already has, but may change
py3 $M/insert-analytics.py gadgets/index.html

cd $W
py3 _PUBLISH.py | tail -n 20

cd UNION
py3 $Z/zip-create.py gadgets.zip gadgets -skipcruft | tail -n 20

SCP gadgets.zip htdocs
SSH <<-EOF
	cd htdocs
	rm -rf gadgets/
	unzip -d . gadgets.zip
	rm gadgets.zip
	exit
	EOF

mv gadgets.zip $C/thumbspage/_private/gadgets--$stamp.zip


#----------------------------------------------------------------------
announce site-mobile-screenshots
#----------------------------------------------------------------------

#
# Update: as of 2.2, this script could use setting=value config arguments
# in its thumbspage command line, instead of editing the config file with 
# a sed command.  For example:
#
#     py3 $C/thumbspage/thumbspage.py site-mobile-screenshots \
#                 thumbsBgColor=\'#123456\' \
#                 thumbsFgColor=\'white\' ... <<-EOF
#
# This also makes the file save/restore unnecessary.
# See also ../examples/2.2-upgrades/config-args-demo.sh for a full demo.
# Nit: the former test for #f5f5f5 here had to change to 2.2's lightgrey.
#

cd $W/Posts/Current/Complete

# save configs file for edits
mv $C/thumbspage/user_configs.py $C/thumbspage/user_configs.py.bkp

# edit configs
sed -e "s/thumbsBgColor = 'lightgrey'/thumbsBgColor = '#123456'/" \
    -e "s/thumbsFgColor = 'black'/thumbsFgColor = 'white'/" \
    -e "s/viewerBgColor = 'black'/viewerBgColor = '#123456'/" \
	< $C/thumbspage/user_configs.py.bkp > $C/thumbspage/user_configs.py

# build gallery
py3 $C/thumbspage/thumbspage.py site-mobile-screenshots <<-EOF
	
	3
	
	
	EOF

# restore configs asap
mv $C/thumbspage/user_configs.py.bkp $C/thumbspage/user_configs.py

# in s-mobile-s index.html, not in viewable HEADER.html
py3 $M/insert-analytics.py site-mobile-screenshots/index.html

cd  $W
py3 _PUBLISH.py | tail -n 20

cd UNION
py3 $Z/zip-create.py site-mobile-screenshots.zip site-mobile-screenshots \
        -skipcruft | tail -n 20

SCP site-mobile-screenshots.zip htdocs
SSH <<-EOF
	cd htdocs
	rm -rf site-mobile-screenshots/
	unzip -d . site-mobile-screenshots.zip
	rm site-mobile-screenshots.zip
	exit
	EOF

mv site-mobile-screenshots.zip $C/thumbspage/_private/site-mobile-screenshots--$stamp.zip


#----------------------------------------------------------------------
announce android-tkinter
#----------------------------------------------------------------------

# Caution: see also nested ALL.zip for code changes

cd $C/android-tkinter
py3 $C/thumbspage/thumbspage.py android-tkinter <<-EOF
	
	3
	
	
	EOF

py3 $C/thumbspage/thumbspage.py android-tkinter/Sizing/ <<-EOF
	
	3
	
	
	EOF

pubdir=$W/Programs/Current/Complete
rm -rf $pubdir/android-tkinter
cp -p  $C/android-tkinter/using-tkinter-programs-on-android.html $pubdir
cp -Rp $C/android-tkinter/android-tkinter $pubdir

# pre analytics/.htaccess
cd $pubdir
py3 $Z/zip-create.py android-tkinter.zip android-tkinter -skipcruft | tail -n 20

# live versions
py3 $M/insert-analytics.py using-tkinter-programs-on-android.html
py3 $M/insert-analytics.py android-tkinter/index.html
py3 $M/insert-analytics.py android-tkinter/Sizing/index.html

# don't inherit this from root
cp -p $C/android-tkinter/.htaccess android-tkinter/CODE
cp -p $C/android-tkinter/.htaccess android-tkinter/etc

cd $W
py3 _PUBLISH.py | tail -n 20

cd UNION
cp -p android-tkinter.zip $C/android-tkinter/_private_/android-tkinter--$stamp.zip

# or use a combined zip like thumbspage?
SCP using-tkinter-programs-on-android.html htdocs    # needed iff changed
SCP android-tkinter.zip htdocs

SSH <<-EOF
	cd htdocs
	rm -rf android-tkinter           # from root
	unzip -d . android-tkinter.zip   # remakes a-t/
	exit
	EOF
# keeps android-tkinter.zip in site root

# upload parts that differ from user zip: analytics, .htaccess
extras='index.html Sizing/index.html CODE/.htaccess etc/.htaccess'
for extra in $extras; do
    SCP android-tkinter/$extra htdocs/android-tkinter/$extra
done

# keeps android-tkinter.zip in local root


#----------------------------------------------------------------------
announce mergeall-android-scripts
#----------------------------------------------------------------------

cd $C/mergeall/mergeall-android-scripts
galleries='. EXFAT-BUG PYDROID3-TKINTER EXFAT-BUG/FIXED-IN-ANDROID-10'

for gallery in $galleries; do
    py3 $C/thumbspage/thumbspage.py _readme-items/$gallery <<-EOF
	
	3
	
	
	EOF
done

cd $C/mergeall
py3 $Z/zip-create.py mergeall-android-scripts.zip mergeall-android-scripts \
        -skipcruft | tail -n 20

pubdir=$W/Programs/Current/Complete
rm -rf $pubdir/mergeall-android-scripts
cp -p  mergeall-android-scripts.zip $pubdir
cp -Rp mergeall-android-scripts $pubdir
mv mergeall-android-scripts.zip _private_/mergeall-android-scripts--${stamp}.zip

cd $pubdir/mergeall-android-scripts
py3 $M/insert-analytics.py _README.html
for gallery in $galleries; do
    py3 $M/insert-analytics.py _readme-items/$gallery/index.html
done

cd $W
py3 _PUBLISH.py | tail -n 20

cd UNION
SCP mergeall-android-scripts.zip htdocs
SSH <<-EOF
	cd htdocs
	rm -rf mergeall-android-scripts
	unzip -d . mergeall-android-scripts.zip
	exit
	EOF

# replace unzipped analytics parts (improve me?)
cd mergeall-android-scripts
SCP _README.html htdocs/mergeall-android-scripts
for gallery in $galleries; do
    SCP _readme-items/$gallery/index.html \
        htdocs/mergeall-android-scripts/_readme-items/$gallery
done

# keeps .zip both on server and local 


#----------------------------------------------------------------------
announce mergeall-android11-updates
#----------------------------------------------------------------------

cd $W/Programs/Current/Complete
py3 $C/thumbspage/thumbspage.py mergeall-android11-updates-media <<-EOF
	
	2
	120, 120
	
	EOF

# already have now, but may change
py3 $M/insert-analytics.py mergeall-android11-updates.html
py3 $M/insert-analytics.py mergeall-android11-updates-media/index.html

cd $W
py3 _PUBLISH.py | tail -n 20
cd UNION

# samba copies on macos botch perms
chmod 777 mergeall-android11-updates-media/*.*
py3 $Z/zip-create.py mergeall-android11-updates-media.zip \
        mergeall-android11-updates-media \
        -skipcruft | tail -n 20

SCP mergeall-android11-updates.html htdocs
SCP mergeall-android11-updates-media.zip htdocs

SSH <<-EOF
	cd htdocs
	rm -rf mergeall-android11-updates-media
	unzip -d . mergeall-android11-updates-media.zip
	rm mergeall-android11-updates-media.zip
	exit
	EOF

rm mergeall-android11-updates-media.zip


#----------------------------------------------------------------------
announce frigcal-screenshots
#----------------------------------------------------------------------

# all apps follow this model
cd $C/frigcal/docetc/docimgs

# the root page could be an imageless gallery page, but isn't
platforms='macosx windows linux'

# build 3 galleries (+ android someday?)
for platform in $platforms; do
    py3 $C/thumbspage/thumbspage.py $platform <<-EOF
	
	
	
	
	EOF
done	

# cp docimgs/ to deleted pub version
cd $W/Programs/Current/Complete/frigcal-products/unzipped/docetc
rm -rf docimgs
cp -pR $C/frigcal/docetc/docimgs .

# installed tag comment in all 4 (HEADER in galleries)
py3 $M/insert-analytics.py docimgs/index.html
for platform in $platforms; do
    py3 $M/insert-analytics.py docimgs/$platform/index.html
done

# publish to union and zip; adds ip-anon line to all index.html for zip+upload
cd $W
py3 _PUBLISH.py | tail -n 20
cd UNION/frigcal-products/unzipped/docetc
py3 $Z/zip-create.py docimgs.zip docimgs -skipcruft | tail -n 20

# upload, unzip, remove
SCP docimgs.zip htdocs/frigcal-products/unzipped/docetc
SSH <<-EOF
	cd htdocs/frigcal-products/unzipped/docetc
	rm -rf docimgs
	unzip -d . docimgs.zip
	rm docimgs.zip
	exit
	EOF

rm docimgs.zip    # local copy in UNION




#------------------------------------------------------------------------
# AND SO ON... there are additional external clients of thumbspage on 
# its host website, trimmed here because they are specific to the host 
# site only, and the clients above suffice to sample automated builds.
# See x-publish-external-demos-prod/_PUBLISH.py for the site's full set.
#------------------------------------------------------------------------

echo
echo 'External builds stopping at:' $(date)
