#!/usr/bin/python
"""
A simple, limited-scope source-lines-of-code (a.k.a. sloc) script.
"""

# py 2.X compatibility
from __future__ import print_function
import sys
if sys.version_info[0] == 2: input = raw_input

import os, glob, sys
tally = count = 0

mains  = glob.glob('*.py*')
mains += ['template-viewpage.html',                  # half of the magic is html
          'template-floatingtop.html'] 

print('Main files...')
for fname in sorted(mains):                          # files in this dir
    if not fname.startswith(('__sloc',)):            # skip self, keep __init__
        fobj = open(fname)
        lcnt = len(fobj.readlines())
        tally += lcnt
        count += 1
        print(fname, '=>', lcnt)
        
print('Total sloc in %d main files: %s\n' % (count, tally))

print('Plus others...')
builds = ['build/_PUBLISH.sh'] + glob.glob('build/*.py')          

for fname in builds:                                 # files in build subdir
    fobj = open(fname)
    lcnt = len(fobj.readlines())
    tally += lcnt
    count += 1
    print(fname, '=>', lcnt)

print('Total sloc in %d files: %s' % (count, tally))

if sys.platform.startswith('win'):
    input('Press Enter')  # if clicked


"""
================================================================================
Current output (manifest):

Main files...
template-floatingtop.html => 73
template-viewpage.html => 2026
thumbspage.py => 1786
user_configs.py => 660
viewer_thumbs.py => 887
Total sloc in 5 main files: 5432

Plus others...
build/_PUBLISH.sh => 458
build/generate-examples.py => 103
build/userguide-online-links.py => 163
build/insert-analytics.py => 323
Total sloc in 9 files: 6479

================================================================================
"""
