#!/usr/bin/python3
"""
simple source-code line count script, used for dev metrics only
"""
import os, glob, sys

srcenc = 'utf8'                                       # configs file now utf-8
gadgets, extras = [], []

def globber(path):
    return glob.glob(path.replace('/', os.sep))

# gadget subdirectories
gadgets += globber('_PyCalc/*/*.py*')
gadgets += globber('_PyClock/*/*.py*')
gadgets += globber('_PyPhoto/*/*.py*')
gadgets += globber('_PyToe/*/*.py*')

# app/exe build scripts count too (but skip iconify.py)
extras += globber('build/build-app-exe/*/build.py')
extras += globber('build/build-source/build.py')

tally = count = 0
for fname in glob.glob('*.py*') + gadgets + extras:   # files in this dir and subs
    if not fname.startswith('__'):                    # skip self and extras in '.'
        fobj = open(fname, encoding=srcenc)
        lcnt = len(fobj.readlines())
        tally += lcnt
        count += 1
        print(fname, '=>', lcnt)
        
print('Total sloc in %d files: %s' % (count, tally))
if sys.platform.startswith('win'):
    input('Press Enter')  # if clicked on Windows


"""
================================================================================
example output (and current counts/manifest):

fixfrozenpaths.py => 125
guimaker_pp4e.py => 110
helpmessage.py => 72
pickcolor.py => 83
PyGadgets.py => 333
PyGadgets_bar.pyw => 10
PyGadgets_configs.py => 326
windowicons.py => 79
_PyCalc/Calculator/__init__.py => 1
_PyCalc/Calculator/calculator.py => 596
_PyCalc/Calculator/getConfigs.py => 78
_PyCalc/Calculator/guimaker_pp4e.py => 110
_PyCalc/Calculator/helpmessage.py => 72
_PyCalc/Calculator/windowicons.py => 79
_PyClock/Clock/__init__.py => 3
_PyClock/Clock/clock.py => 727
_PyClock/Clock/clockStyles.py => 106
_PyClock/Clock/getConfigs.py => 78
_PyClock/Clock/guimaker_pp4e.py => 110
_PyClock/Clock/helpmessage.py => 72
_PyClock/Clock/plotterGui.py => 44
_PyClock/Clock/plotterText.py => 26
_PyClock/Clock/windowicons.py => 79
_PyPhoto/PIL/delete-pyphoto2.0-thumbs-folders.py => 54
_PyPhoto/PIL/getConfigs.py => 78
_PyPhoto/PIL/guimaker_pp4e.py => 110
_PyPhoto/PIL/helpmessage.py => 72
_PyPhoto/PIL/pyphoto.py => 935
_PyPhoto/PIL/viewer_thumbs.py => 774
_PyPhoto/PIL/windowicons.py => 79
_PyToe/TicTacToe/__init__.py => 3
_PyToe/TicTacToe/getConfigs.py => 78
_PyToe/TicTacToe/helpmessage.py => 72
_PyToe/TicTacToe/tictactoe.py => 182
_PyToe/TicTacToe/tictactoe_lists.py => 564
_PyToe/TicTacToe/windowicons.py => 79
build/build-app-exe/linux/build.py => 211
build/build-app-exe/macosx/build.py => 186
build/build-app-exe/windows/build.py => 239
build/build-source/build.py => 96
Total sloc in 40 files: 7131
================================================================================
"""
