# stdout context display (see also contextdump.py's GUI variant)
"""
------------------------------------------------------------------------------
On Unix, enter cmdline args: 
    -a\ bx -x "c d" -y "-l m n" "o\p"
sys.argv:
    ['/.../envtest2.py', '-a bx', '-x', 'c d', '-y', '-l m n', 'o\\p']

On Windows, argument escapes are supported but differ; sys.argv for same args:
    ['...\\envtest2.py', '-a\\', 'bx', '-x', 'c d', '-y', '-l m n', 'o\\p']

Run Code supports shell syntax for arguments, and quotes or escapes the names
of the file and the Python executable as required for the host platform.
------------------------------------------------------------------------------
"""

from __future__ import print_function

import sys, os
print('path:', sys.path)
print('-'*40)
print('exec:', sys.executable)
print('-'*40)
print('argv:', sys.argv)
print('-'*40)
print('file:', __file__)
print('-'*40)
print('PATH:', os.environ['PATH'])
print('-'*40)
print('env:')
for key in sorted(os.environ):
   print(key, '=>', os.environ[key])


# expected output (on Mac app)------------------------------------------------
"""
path: ['/MY-STUFF/Code/pymailgui/PyMailGui-PP4E/PP4E/Gui/TextEditor/docetc/examples/RunCode-examples', '/Applications/PyEdit.app/Contents/Resources/lib/python35.zip', '/Applications/PyEdit.app/Contents/Resources/lib/python3.5', '/Applications/PyEdit.app/Contents/Resources/lib/python3.5/plat-darwin', '/Applications/PyEdit.app/Contents/Resources/lib/python3.5/lib-dynload', '/Applications/PyEdit.app/Contents/Resources/lib/python3.5/site-packages.zip', '/Applications/PyEdit.app/Contents/Resources/lib/python3.5/site-packages']
----------------------------------------
exec: /Applications/PyEdit.app/Contents/MacOS/python
----------------------------------------
argv: ['/MY-STUFF/Code/pymailgui/PyMailGui-PP4E/PP4E/Gui/TextEditor/docetc/examples/RunCode-examples/envtest2.py', '-a bx', '-x', 'c d', '-y', '-l m n', 'o\\p']
----------------------------------------
file: /MY-STUFF/Code/pymailgui/PyMailGui-PP4E/PP4E/Gui/TextEditor/docetc/examples/RunCode-examples/envtest2.py
----------------------------------------
PATH: /usr/bin:/bin:/usr/sbin:/sbin
----------------------------------------
env:
ARGVZERO => /Applications/PyEdit.app/Contents/MacOS/PyEdit
Apple_PubSub_Socket_Render => /private/tmp/com.apple.launchd.SIGW7MlqnP/Render
EXECUTABLEPATH => /Applications/PyEdit.app/Contents/MacOS/PyEdit
HOME => /Users/blue
LC_CTYPE => en_US.UTF-8
LOGNAME => blue
PATH => /usr/bin:/bin:/usr/sbin:/sbin
PWD => /Applications/PyEdit.app/Contents/Resources
PYTHONDONTWRITEBYTECODE => 1
PYTHONHOME => /Applications/PyEdit.app/Contents/Resources
PYTHONIOENCODING => UTF8
PYTHONPATH => /Applications/PyEdit.app/Contents/Resources
RESOURCEPATH => /Applications/PyEdit.app/Contents/Resources
SHELL => /bin/bash
SHLVL => 1
SSH_AUTH_SOCK => /private/tmp/com.apple.launchd.3syzIob72U/Listeners
TMPDIR => /var/folders/fp/pwb6m7wd67s0thjwfr1ckw480000gn/T/
USER => blue
XPC_FLAGS => 0x0
XPC_SERVICE_NAME => org.lutzware.PyEdit.142432
_ => /Applications/PyEdit.app/Contents/MacOS/python
_PY2APP_LAUNCHED_ => 1
__CF_USER_TEXT_ENCODING => 0x1F5:0x0:0x0
[EOF]
"""
