#!/usr/bin/python3
"""
======================================================================================
Convenience script to launch pyedit from arbitrary places with the import path
set as required for PyEdit's original location in the PP4E book examples package.
This was located in the PyEdit's TextEditor/ root folder in PP4E's examples.

This is *not required* for the launchable PyEdit shipped with PyMailGUI 4.0, or
the newer PyEdit standalone source-code, Mac app, and Windows and Linux executable
packages.  The PyMailGUI launchable version hardcodes the 3-up path to the embedded
PP4E, and the standalone PyEdits either nest the PP4E folder or freeze all their
dependencies to avoid path settings altogether.

Sys.path for imports and dir for open() here must be relative to the known top-level
script's dir, not cwd -- cwd is script's dir if run by shortcut or icon click,
but may be anything if run from command-lines in console windows: use argv path.

This is a .pyw to suppress console pop-ups on Windows; add this script's dir to your 
system PATH to run from command-lines; it works on Unix too: / and \ handled portably.
See also pyedit.bat in PyMailGUI 4.0 release, for associating PyEdit with all '.txt'.
======================================================================================
"""

# Python 3.3 on Windows fix: needs python3 in #! for inline spawnee

import sys, os                                           # argv[0]=script, not python
mydir = os.path.dirname(sys.argv[0])                     # use my dir for open, path
print(sys.argv)
sys.path.insert(1, os.sep.join([mydir] + ['..']*3))      # imports: PP4E root, 3 up 
exec(open(os.path.join(mydir, 'textEditor.py')).read())
