#!/usr/bin/env python3
"""
=============================================================================
Make a PyEdit source-code package (a zipfile with nested PP4E folder).
Run this script in the dir that contains it, no args.  It never chdirs.

This is just a few moves and a zip; there are no frozen builds here.
Unlike the app/exe scripts, this may be run on Windows, Mac, or Linux.

*NOTE*: remove any unzipped app/exe folders in build/ before running this.
=============================================================================
"""

import os, sys, shutil
join, sep = os.path.join, os.path.sep
startdir = os.getcwd()                    # this build script's dir

# 'python3' fails in both IDLE and PyEdit RunCode (env's PATH not inherited?)
python = sys.executable

# not built on Android, currently on macOS
RunningOnWindows = sys.platform.startswith('win')
RunningOnMacOS   = sys.platform.startswith('darwin')
RunningOnLinux   = sys.platform.startswith('linux')

#----------------------------------------------------------------------------
# make app's icon if one doesn't already exist
#----------------------------------------------------------------------------

pass  # handle this manually in build-app-exe, as icons differ per platform

#----------------------------------------------------------------------------
# copy PP4E, move its TextEditor to root, and nest PP4E inside it;
#----------------------------------------------------------------------------

# automated setup - run in this file's dir

if RunningOnMacOS:
    temp = '/Users/me/Desktop/tempsrc'             # cp can't include self!
elif RunningOnWindows:
    temp = r'C:\Users\you\Desktop\tempsrc'         # or use $HOME, etc.
elif RunningOnLinux:
    temp = '/home/me/Desktop/tempsrc'

if os.path.exists(temp):
    shutil.rmtree(temp)
os.mkdir(temp)

# move all to temp, nest PP4E in TextEditor
print('Building tree')
shutil.copytree(join('..', '..', '..', '..', '..', 'PP4E'),
                join(temp, 'PP4E'), symlinks=True) 
shutil.move(join(temp, 'PP4E', 'Gui', 'TextEditor'), temp)   # move nested up to temp root
shutil.move(join(temp, 'PP4E'), join(temp, 'TextEditor'))    # move PP4E down to nested

#----------------------------------------------------------------------------
# make the source zipfile
#----------------------------------------------------------------------------

# zip command: use portable ziptools (vs: 'zip -r %s %s' % (thezip, thedir))
thedir = 'PyEdit--source'
thezip = thedir + '.zip'

if RunningOnMacOS:
    code = '/Users/me/MY-STUFF/Code/ziptools/link'
elif RunningOnWindows:
    code = r'C:\Users\me\Desktop\MY-STUFF\Code\mergeall\test\ziptools'    # no symlink
elif RunningOnLinux:
    code = '/media/me/Users/me/Desktop/MY-STUFF/Code/mergeall/test/ziptools'    # mounted

zipit = '%s %s/zip-create.py %s %s -skipcruft' % (python, code, thezip, thedir)
zipit = zipit.replace('/', os.sep)

# rename and move source product folder from temp to build-script's dir
shutil.move(join(temp, 'TextEditor'), join(temp, thedir))
if os.path.exists(thedir):
    shutil.rmtree(thedir)                      # nuke bogus retained temp?
shutil.move(join(temp, thedir), '.')
shutil.rmtree(temp)                            # rm temp build tree 

# remove zipped app, exes, src in the build tree for space
for (root, subs, files) in os.walk(join(thedir, 'build')):
    for file in files:
        if file.endswith('.zip') and 'autosaves' not in file:    # as.zip: docetc/examples
            filepath = join(root, file)
            print('Removing', filepath)
            os.remove(filepath)
            dummy = open(filepath + '.stripped', 'w')
            dummy.write('**REMOVED**')
            dummy.close()

# remove any personal auto-save files
asave = join(thedir, '__pyedit-autosaves__')
for item in os.listdir(asave):
    if item != 'README-autosaves.txt':
        itempath = join(asave, item)
        print('Removing', itempath)
        os.remove(itempath)

# drop other non-public stuff (not sloc.py or auto-saves; keep .htccess for completeness only)
shutil.rmtree(join(thedir, '__pycache__'))
shutil.rmtree(join(thedir, '__private__'))
shutil.rmtree(join(thedir, '_private_'))       # old shrinkpix stuff

# zip the reorganized source folder
if os.path.exists(thezip):
    shutil.move(thezip, 'prev-'+thezip)        # save previous version
os.system(zipit)                               # run zip in build-source
shutil.rmtree(thedir)                          # rm temp folder copy here

print('Done: see', thezip)

# +unzip and copy elsewhere for easy access
