#!/bin/sh 
#
# Run on Mac: automatic image resize + icon build.
#

# extract lower-res sizes
./resize-on-mac.sh Pyedit1024 images-pyedit

# mac uses just one general icon, all image sizes
python3 iconify.py -mac images-pyedit pyedit

# windows general icon uses same sizes set
python3 iconify.py -win images-pyedit pyedit

# make smaller Windows border icon (mac doesn't use)
rm -rf images-pyedit-window-main
mkdir  images-pyedit-window-main
cp images-pyedit/Pyedit1024_32x32.png images-pyedit-window-main
python3 iconify.py -win images-pyedit-window-main pyedit-window-main

# popup now uses same as main
cp pyedit-window-main.ico pyedit-window-popup.ico

# windows subprocproxy uses a custom set
python3 iconify.py -win images-pyedit-subprocproxy pyedit-subprocproxy

# move the lot to the ship folder
mv pyedit.icns ../icons
mv pyedit.ico ../icons
mv pyedit-window-main.ico ../icons
mv pyedit-window-popup.ico ../icons
mv pyedit-subprocpoxy.ico ../icons

# tbd: Linux GIFs via sip too?

# no longer used
# ./resize-on-mac.sh Pyedit1024popup images-pyeditpopup
# rm -rf images-pyedit-window-popup
# mkdir images-pyedit-window-popup
# cp images-pyedit/Pyedit1024_32x32.png images-pyedit-window-popup 
# python3 iconify.py -win images-pyedit-window-popup pyedit-window-popup
