ECHO OFF
REM ------------------------------------------------------------------------
REM make a Windows single-file executable with PyInstaller
REM this allows text files to be associated to open in PyEdit on clicks
REM
REM there is no setup.py file for PyIstaller
REM didn't get cx_freeze or py2exe to work, but stopped short...
REM
REM moved PP4E pkg root (less TextEditor) to be nested here, not above;
REM win exe didn't require any changes, other than sys.path=argv[0]
REM
REM need textConfig to be source code, and user-visible/editable
REM need icon for both the exe, and window borders in Tk runtime 
REM
REM pyinstaller sets cwd to anything; uses dir of sys.argv[0],
REM and copy files to folder holding exe for .=exe's dir
REM ------------------------------------------------------------------------

REM ------------------------------------------------------------------------
REM first:   copy PP4E, move its TextEditor to root, and nest PP4E inside it
REM then:    copy this up to TextEdit folder and run it there
REM finally: copy .\dist with pyedit.exe here, zip+post folder
REM ------------------------------------------------------------------------

REM ------------------------------------------------------------------------
REM clean up last run
REM ------------------------------------------------------------------------

rmdir /S /Q build
rmdir /S /Q dist

REM ------------------------------------------------------------------------
REM build one-file exe in ./dist
REM ------------------------------------------------------------------------

pyinstaller                     ^
    --onefile                   ^
    --windowed                  ^
    --icon icons\pyedit.ico     ^
    --exclude-module textConfig ^
    textEditor.py

REM ------------------------------------------------------------------------
REM use app (not script) name
REM ------------------------------------------------------------------------

rename dist\textEditor.exe PyEdit.exe

REM ------------------------------------------------------------------------
REM copy extras to exe's folder: textEditor.py arranges to see these;
REM not --add-data: it gets unzipped in a Temp dir the user won't see...
REM ------------------------------------------------------------------------

copy textConfig.py dist
copy README.txt dist    
xcopy /E /I icons dist\icons
xcopy /E /I docetc dist\docetc
copy UserGuide.html dist
copy subprocProxy.py dist

