#!/bin/sh
#----------------------------------------------------------------------------
# Make a Mac OS X app bundle (folder), using py2app.
# This could be coded in Python, but time is short for a conversion.
#
# An app allows text files to be associated to auto-open in PyEdit on clicks
# (but also does a woefully-good job of hiding user-config source files!)
#
# Didn't get cx_freeze or pyinstaller to work, but stopped short...
# -pyinstaller had issues with Active Tcl/Tk, cx_freeze had xcode issues (?)
# -pyinstaller may be retried if use homebrew python/tk for menu/dock issues; 
#
# Moves PP4E pkg root (less TextEditor) to be nested here, not above.
# Mac app required: tailoring apple/window menus, __main__ workaround
# for opendoc events, sys.path=., and a mac-format .icns icon (the
# latter became an iconify.py extension).
#
# Need textConfig to be source code, and user-visible and editable;
# Need icon for both the exe, and window borders in Tk at runtime;
# Need UserGuide.html and docetc items it uses at runtime;
# 
# py2app sets the cwd to the bundle's Contents/Resource folder in all cases:
# add '.' to sys.path in textEditor.py, and use files copied to .=Resources,
# to which __file__ will refer.
#
# Windows were not opening on first click (in dock): need __main__ 
# workaround and disable py2app's broken argv emulation in setup.py.
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
# make app's icon if one doesn't already exist
#----------------------------------------------------------------------------

iconpath=../../icons
iconname=pyedit

if [ ! -e $iconpath/$iconname.icns ]
then
   pushd $iconpath/build-icons
   #iconutil -c icns pyedit.iconset
   python3 iconify.py -mac images $iconname
   cp $iconname.icns ..
   popd
fi

#----------------------------------------------------------------------------
# [update - setup and teardown steps are now automated (run this script in 
# its dir), and Info.plist edits are now automatic by setup.py options;]
#
# first:   copy PP4E, move its TextEditor to root, and nest PP4E inside it
# then:    copy this+setup.py up to TextEdit folder and run this there 
# finally: copy .dist with PyEdit.app here, zip+post, productbuild .pkg 
#----------------------------------------------------------------------------

# automated setup - run in this file's dir
temp=~/Desktop/tempsrc                      # cp can't include self
mkdir $temp
cp -R ../../../../../PP4E $temp
mv $temp/PP4E/Gui/TextEditor $temp
mv $temp/PP4E $temp/TextEditor
cp setup.py $temp/TextEditor
pushd $temp/TextEditor
 
#----------------------------------------------------------------------------
# [old] clean up last run (now pointless if fresh copy each time)
#----------------------------------------------------------------------------

# rm -rf build dist 

#----------------------------------------------------------------------------
# use PyEdit name for both the app-bundle folder and auto-menu title;
# this name must also be used in this project's setup.py file here;
# we can't rename these afer the build, and "textEditor.py" is ingrained;
#----------------------------------------------------------------------------

cp textEditor.py PyEdit.py

#----------------------------------------------------------------------------
# build app-bundle folder in ./dist, using ./setup.py, copying 5 extras
#----------------------------------------------------------------------------

python3 setup.py py2app \
    --excludes textConfig \
    --resources textConfig.py,docetc,icons,UserGuide.html,README.txt \
    --iconfile icons/pyedit.icns

#----------------------------------------------------------------------------
# [old] cleanup temp rename file (now pointless if fresh copy each time)
#----------------------------------------------------------------------------

# rm PyEdit.py

#----------------------------------------------------------------------------
# [update - teardown actions are now automated (but still no data to copy)]
# don't copy extras to Contents/Resources folder here: automatic via 
# py2app args above;  textEditor.py arranges to see these as needed;
#----------------------------------------------------------------------------

# automated teardown
popd
rm -rf dist
mv $temp/TextEditor/dist .
rm -rf $temp
rm dist.zip                  # zip the app: may be thousands of files!
zip -r dist dist             # unzip to test and use here
echo 'Done: see ./dist'
