#!/bin/sh
#--------------------------------------------------------------------------
# make a Linux single-file executable with PyInstaller,
# and manually copy some data items to its folder;
# there is no setup.py file for PyIstaller;
#
# associating files with executables on Linux can 
# be tedious (e.g., editing /usr/share mime-list 
# and .desktop files): see the web for resources:
# https://duckduckgo.com/?q=associate+program+with+file+ubuntu
#--------------------------------------------------------------------------

#--------------------------------------------------------------------------
# first:   copy PP4E, move its TextEditor to root, and nest PP4E inside it
# then:    copy this up to TextEdit folder and run it there
# finally: copy ./dist with executable here, zip+post folder
#--------------------------------------------------------------------------

#--------------------------------------------------------------------------
# clean up last run
#--------------------------------------------------------------------------

rm -rf build dist

#--------------------------------------------------------------------------
# build one-file exe in ./dist
#--------------------------------------------------------------------------

pyinstaller --onefile --windowed --icon icons/pyedit.gif --exclude-module textConfig textEditor.py 

#--------------------------------------------------------------------------
# use app (not script) name
#--------------------------------------------------------------------------

mv dist/textEditor dist/PyEdit

#--------------------------------------------------------------------------
# copy extras to exe's folder: textEditor.py arranges to see these;
# not --add-data: it gets unzipped in a Temp dir the user won't see...
#--------------------------------------------------------------------------

cp textConfig.py dist
cp README.txt dist    
cp -r icons dist
cp -r docetc dist
cp UserGuide.html dist
cp subprocProxy.py dist
