#!/usr/bin/python
# dump start of file in hex + parsed fields
# run directly, or via test_ALL

from __future__ import print_function
import sys, struct
if sys.version[0] == '2': input = raw_input
def cnv(x): return ord(x) if sys.version[0] == '2' else x

testico = sys.argv[1] if len(sys.argv) > 1 else 'test_icon'

# dump little-endian hex bytes
rawbytes = open(testico + '.ico', 'rb').read()
for i in range(80):
    print('%2X' % cnv(rawbytes[i]), end=' ')         # 2.X only: ord() for int
    if (i+1) % 20 == 0: print()

# dump human-readable fields
print('\nParsed fields:')
hdrfmt = "<hhh"         # hdr: 6 bytes
dirfmt = "<BBBBhhii"    # dir: 16 bytes each

# header
vals = struct.unpack(hdrfmt, rawbytes[0:6])
print('\treserved:  %s\n'
      '\tfiletype:  %s\n'
      '\tnumimages: %s' % vals)

# directory
rawbytes = rawbytes[6:]
for i in range(vals[2]):
    dirrec, rawbytes = rawbytes[:16], rawbytes[16:]
    vals = struct.unpack(dirfmt, dirrec)
    print('record %s:\n'
          '\twidth:     %s\n'
          '\theight:    %s\n'
          '\tcolors:    %s\n'
          '\treserved:  %s\n'
          '\tplanes:    %s\n'
          '\tbitspix:   %s\n'
          '\timgsize:   %s\n'
          '\timgoffset: %s\n' % ((i,) + vals))

input('Press Return to exit.')
