"""
=========================================================
Parse and display the structure of an Apple .icns file,
whose name is passed in as a command line argument.
See iconify.py for creating .icns (and .ico) files,
and for links to details on icon format and type codes.
=========================================================
"""
import sys, struct
file = open(sys.argv[1], 'rb')

# 8-byte header
magic = file.read(4)
print('Magic:       ', magic)

filelen = struct.unpack('>I', file.read(4))
print('File length: ', filelen[0])

# list of length+imagedata
while True:
    type_ = file.read(4)
    if not type_:
        break  # eof
    print('-' * 40)
    print('Icon type:   ', type_)

    imglen = struct.unpack('>I', file.read(4))
    print('Image length:', imglen[0])

    imgdata = file.read(imglen[0] - 8)  # less type+length 
    print('Image data:  ')
    print(imgdata[:100])    # first bytes
    print('...')
    print(imgdata[-100:])   # last bytes

print('-' * 40)
rest = file.read()
print('Remainder:   ', rest)
assert rest == b''
