# various compatibility stuff for quick fixups (which doubles as a
# note to revisit that code later on).  don't even think of using
# something in here for new code.

import builtins

class _C:
    def _m(self):
        pass
def _f():
    pass
_callables = type(_C), type(_C._m), type(_C()._m), type(len)

# --------------------------------------------------------------------

def apply(func, args, kw=None):
    return func(*args, **(kw or {}))

def callable(func):
    return isinstance(func, _callables)

def chr(v):
    return bytes([v]) # usage: chr(i) when used code expects a byte array

def filter(func, seq):
    return list(builtins.filter(func, seq))

def has_key(dict, key):
    return key in dict

def map(func, seq):
    return list(builtins.map(func, seq))

def ord(v):
    if isinstance(v, bytes):
        return v[0]
    return v # usage: ord(b[i]) where b is a bytes array

def range(*args):
    return list(builtins.range(*args))
