# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# [START dataplex_delete_aspect_type]
from google.cloud import dataplex_v1


def delete_aspect_type(project_id: str, location: str, aspect_type_id: str) -> None:
    """Method to delete Aspect Type located in project_id, location and with aspect_type_id"""

    # Initialize client that will be used to send requests across threads. This
    # client only needs to be created once, and can be reused for multiple requests.
    # After completing all of your requests, call the "__exit__()" method to safely
    # clean up any remaining background resources. Alternatively, use the client as
    # a context manager.
    with dataplex_v1.CatalogServiceClient() as client:
        # The resource name of the Aspect Type
        name = (
            f"projects/{project_id}/locations/{location}/aspectTypes/{aspect_type_id}"
        )
        client.delete_aspect_type(name=name)


if __name__ == "__main__":
    # TODO(developer): Replace these variables before running the sample.
    project_id = "MY_PROJECT_ID"
    # Available locations: https://cloud.google.com/dataplex/docs/locations
    location = "MY_LOCATION"
    aspect_type_id = "MY_ASPECT_TYPE_ID"

    delete_aspect_type(project_id, location, aspect_type_id)
    print("Successfully deleted aspect type")
# [END dataplex_delete_aspect_type]
