# Code samples for the Compute Engine library

In this folder you can find the source code for the code samples used throughout the 
[public documentation](https://cloud.google.com/compute/docs/) of Google Compute Engine.

The samples can be found in the `snippets` folder, where they are organized to mimic the
structure of the public documentation. Files that are saved there are generated by the `sgs.py`
script from pieces found in `ingredients` and `recipes`. This way, one piece of code can be easily
included in multiple snippets and updating the code requires less work.

## Working with the SGS

SGS (Snippet Generating System) works by scanning the `recipes` folder, finding all files
and filling them with pieces of code found in `ingredients`. The folder structure of `recipes` is 
reconstructed in the `snippets` folder.

### Adding new sample

To create a new sample, just prepare a new file in one of the `recipes` subfolders. The SGS will pick it up 
automatically when you run it, by executing `python3 sgs.py generate` in this (`samples/`) directory.

### Removing/moving a sample

To remove or move a sample, you need to simply modify the `recipes` folder to match your desired structure, then delete
the generated snippet from the `snippets` directory. The SGS script will create the snippet in the new location next 
time you run `python3 sgs.py generate`.

### Interacting with GIT

SGS will not interact with Git repository in any way. All changes made by the script need to be committed manually - 
preferably in the same commit as the update to the source files.

## Preparing an ingredient
To add a new ingredient, create a new `.py` file with the code you want to later use in the snippets. Mark the beginning
of the code you want to include with `# <INGREDIENT name>` and the end with `# </INGREDIENT>`. 

Please leave the imports required by this ingredient **OUTSIDE** the area marked with ingredient comments. The SGS 
script will automatically collect all the required imports and put them in the final snippet in the right place and in
right order.

## Preparing a recipe
Each recipe is a file located in the `recipes` folder. It should have the `.py` extension and should be a valid Python 
script. Each recipe has to have an `# <IMPORTS/>` line and at least one `# <INGREDIENT name/>` line. 
Apart from those restrictions, the contents of the file can be whatever you want.

The SGS will copy the recipe file to the destination folder in `snippets` and replace the `# <IMPORTS/>` and 
`# <INGREDIENT name/>` lines with the `import` statements required by the used ingredients and with the ingredient
body.

### Regions
You should use `# <REGION region_name>` and `# </REGION region_name>` lines to indicate where start and end
of a region should be placed in the generated snippet. Those lines will be simply replaced with the proper 
`START region_name` and `END region_name` lines.
