# Copyright 2016 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Sample Google App Engine application that demonstrates using the Users API.

For more information about App Engine, see README.md under /appengine.
"""

from google.appengine.api import users
import webapp2


class MainPage(webapp2.RequestHandler):
    def get(self):
        # [START gae_users_get_details]
        user = users.get_current_user()
        if user:
            nickname = user.nickname()
            logout_url = users.create_logout_url("/")
            greeting = 'Welcome, {}! (<a href="{}">sign out</a>)'.format(
                nickname, logout_url
            )
        else:
            login_url = users.create_login_url("/")
            greeting = '<a href="{}">Sign in</a>'.format(login_url)
        # [END gae_users_get_details]
        self.response.write("<html><body>{}</body></html>".format(greeting))


class AdminPage(webapp2.RequestHandler):
    def get(self):
        user = users.get_current_user()
        if user:
            if users.is_current_user_admin():
                self.response.write("You are an administrator.")
            else:
                self.response.write("You are not an administrator.")
        else:
            self.response.write("You are not logged in.")


app = webapp2.WSGIApplication([("/", MainPage), ("/admin", AdminPage)], debug=True)
