# How to become a contributor and submit your own code

## Contributor License Agreements

We'd love to accept your sample apps and patches! Before we can take them, we
have to jump a couple of legal hurdles.

Please fill out either the individual or corporate Contributor License Agreement
(CLA):

  * If you are an individual writing original source code and you're sure you
    own the intellectual property, then you'll need to sign an [individual CLA](https://developers.google.com/open-source/cla/individual).
  * If you work for a company that wants to allow you to contribute your work,
    then you'll need to sign a [corporate CLA](https://developers.google.com/open-source/cla/corporate).

Follow either of the two links above to access the appropriate CLA and
instructions for how to sign and return it. Once we receive it, we'll be able to
accept your pull requests.

## Contributing A Patch

1. Submit an issue describing your proposed change to the repository in question.
2. The repository owner will respond to your issue promptly.
3. If your proposed change is accepted, and you haven't already done so, sign a
   CLA (see details above).
4. Fork the desired repo, then develop and test your code changes.
5. Ensure that your code adheres to the existing style in the sample to which
   you are contributing. Refer to the [Google Java Style Guide](http://google.github.io/styleguide/javaguide.html) and the
   [Google Cloud Platform Community Style Guide](https://cloud.google.com/community/tutorials/styleguide) for the
   recommended coding standards for this organization.
6. Ensure that your code has an appropriate set of unit tests which all pass.
7. Submit a pull request.
